 ; Ŀ
 ;   Cspi - star maker                                                     
 ;   Copyright 1993, 1997 by Rocket Software                               
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Sta - draw an individual grstar                            
 ;   Takes four arguments: top, side length, rotation (radians),           
 ;   and colour.  Returns nothing, but draws a star.                       
 ; 
 (DEFUN STA (pa sidlen rota colo / anginc angg hafang pb)
  (setq anginc (* 1.6 pi))
  (setq angg (+ rota (* 1.6 pi)))
  (setq hafang (* 0.8 pi))
  (repeat 5
         (setq pb (polar pa angg sidlen))
         (grdraw pa pb colo)
         (setq angg (- angg anginc))
         (setq pa pb)
         (setq pb (polar pa angg sidlen))
         (grdraw pa pb colo)
         (setq angg (- angg hafang))
         (setq pa pb))
 (princ))
 ; Ŀ
 ;   Subroutine Sta end.                                                   
 ; 

 ; Ŀ
 ;   Olaf - make a ring of stars.                                          
 ;   Takes four arguments: centre, fraction of screen size, rotation,      
 ;   colour.                                                               
 ; 
 (DEFUN OLAF (pa rad angg colo / vsize angg rad pa2)
  (repeat 18
         (setq pa2 (polar pa angg rad))
         (sta pa2 (* rad 0.05) (- angg (/ pi 2)) colo)
         (setq angg (+ angg (/ pi 9))))
 (princ))
 ; Ŀ
 ;   Olaf end.                                                             
 ; 

 ; Ŀ
 ;   Cspi.                                                                 
 ; 
 (DEFUN C:CSPI (/ blip pa perc angg rad pa2)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (if (null (setq pa (getpoint "Centre <Centre>: ")))
      (setq pa (getvar "viewctr")))
  (setq rad (getvar "viewsize"))
  (setq angg 0)
  (repeat 60
         (olaf pa rad angg 7)
         (setq angg (+ angg (/ pi 16)))
         (setq rad (* rad 0.9)))
  (setvar "blipmode" blip)
 (princ))